<?php
require_once __DIR__ . '/../config.php';
rp_require_login(['admin','manager']);
?>
<!DOCTYPE html>
<html lang="nl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Rooster maken – Roosterprogramma</title>
  <link rel="stylesheet" href="manage.css">
</head>
<body>
  <header class="topbar">
    <div class="brand"><a href="/app/dashboard/" class="back">←</a> Rooster maken</div>
    <nav class="nav">
      <a href="/app/roster/" class="navlink">Rooster bekijken</a>
      <a href="/app/availability/" class="navlink">Beschikbaarheid</a>
      <a href="/app/profile/" class="navlink">Mijn profiel</a>
      <a href="/api/auth/logout.php" class="navlink">Log uit</a>
    </nav>
  </header>

  <main class="wrap">
    <section class="toolbar card">
      <div class="row">
        <div class="field">
          <label>Naam rooster</label>
          <input id="rName" type="text" placeholder="Bijv. Week 42 – Winkel Noord" />
        </div>
        <div class="field">
          <label>Week (maandag)</label>
          <div class="weeknav">
            <button id="prev" class="btn small">◀</button>
            <input id="weekStart" type="date" />
            <button id="next" class="btn small">▶</button>
          </div>
        </div>
        <div class="field">
          <label>Afdelingen</label>
          <div id="deptChecks" class="checks"></div>
        </div>
        <div class="actions">
          <button id="helpBtn" class="btn ghost">Uitleg</button>
          <button id="validateBtn" class="btn ghost">Controleren</button>
          <button id="autoPlan" class="btn ghost">Auto-planner</button>
          <button id="clearWeek" class="btn danger">Week leegmaken</button>
          <button id="saveDraft" class="btn">Opslaan (concept)</button>
          <button id="publish" class="btn primary">Publiceren</button>
        </div>
      </div>
      <div id="note" class="note" hidden></div>
    </section>

    <section class="studio card">
      <aside class="side">
        <h3>Medewerkers</h3>
        <div id="people" class="people"></div>
        <div class="legend">
          <div><span class="dot ok"></span> geldig</div>
          <div><span class="dot warn"></span> waarschuwing</div>
          <div><span class="dot err"></span> conflict</div>
        </div>
      </aside>

      <section class="board" id="board">
        <div class="boardHead">
          <div class="spacer">Tijd</div>
          <div class="days" id="daysHead"></div>
        </div>

        <!-- ✅ Ruler per dagkolom (in plaats van 1 lange) -->
        <div class="rulerRow">
          <div class="rulerLabel"> </div>
          <div class="rulerWeek" id="rulerWeek"></div>
        </div>

        <div class="rows" id="rows"></div>
        <div id="drawOverlay" class="draw" hidden></div>
      </section>
    </section>

    <!-- Conflictpaneel -->
    <section id="confPane" class="card confpane" hidden>
      <div class="confHead">
        <strong>Controle resultaten</strong>
        <span id="confCount" class="badgeCount">0</span>
      </div>
      <div id="confList" class="confList"></div>
    </section>
  </main>

  <!-- Drawer -->
  <div id="drawer" class="drawer" aria-hidden="true">
    <div class="drawer-inner">
      <div class="drawer-head">
        <h3 id="drawerTitle">Nieuwe dienst</h3>
        <button id="drawerClose" class="x" type="button">×</button>
      </div>
      <form id="shiftForm" class="form" novalidate>
        <div class="field"><label>Afdeling</label><select id="fDept"></select></div>
        <div class="grid">
          <div class="field"><label>Datum</label><input id="fDate" type="date" required /></div>
          <div class="field"><label>Start</label><input id="fStart" type="time" required /></div>
          <div class="field"><label>Eind</label><input id="fEnd" type="time" required /></div>
        </div>
        <div class="field"><label>Titel (optioneel)</label><input id="fTitle" type="text" placeholder="Bijv. Kassa / Vakken" /></div>
        <div class="field">
          <label>Pauze (minuten)</label>
          <div style="display:flex; gap:8px; align-items:center;">
            <input id="fBreak" type="number" min="0" step="5" placeholder="0 / 30 / 45" style="flex:1;">
            <button id="autoBreak" class="btn small" type="button">Auto</button>
          </div>
          <small class="muted">Regel: &lt;6u = 0m, 6..8u = 30m, &gt;8u = 45m</small>
        </div>
        <div class="field">
          <label>Medewerkers</label>
          <div class="userpicker" id="userPicker">
            <div class="up-head">
              <input id="upSearch" class="up-search" type="text" placeholder="Zoek naam of e-mail…" />
              <button id="upAll" class="up-clear" type="button" title="Selecteer allen">Allen</button>
              <button id="upClear" class="up-clear" type="button" title="Wissen">Wissen</button>
            </div>
            <div class="up-selected" id="upSelected"></div>
            <div class="up-list" id="upList"></div>
          </div>
          <select id="fUsers" multiple size="1" style="display:none"></select>
        </div>
        <div class="actions">
          <button class="btn" type="submit">Opslaan</button>
          <button id="deleteShift" class="btn danger" type="button" hidden>Verwijderen</button>
        </div>
        <div id="drawerNote" class="note" hidden></div>
      </form>
    </div>
  </div>

  <!-- Auto Planner modal (als eerder) -->
  <div id="autoModal" class="modal" aria-hidden="true">
    <div class="modal-inner">
      <div class="modal-head">
        <h3>Auto-planner</h3>
        <button id="autoClose" class="x" type="button">×</button>
      </div>
      <div class="modal-body">
        <p class="muted">Kies bezetting per dag. Er wordt rekening gehouden met openingstijden, max 8u en pauzes.</p>
        <div id="autoMatrix"></div>
        <div class="actions">
          <button id="genConcept" class="btn">Genereer concept</button>
          <button id="applyConceptAppend" class="btn" disabled>Toevoegen</button>
          <button id="applyConceptReplace" class="btn primary" disabled>Vervangen</button>
        </div>
        <div id="autoPreview" class="autoPrev" hidden></div>
        <div id="autoNote" class="note" hidden></div>
      </div>
    </div>
  </div>

  <!-- Help (als eerder) -->
  <div id="helpModal" class="modal" aria-hidden="true">
    <div class="modal-inner">
      <div class="modal-head">
        <h3>Uitleg</h3>
        <button id="helpClose" class="x" type="button">×</button>
      </div>
      <div class="modal-body">
        <ol>
          <li>Week kiezen (altijd maandag-start) en afdelingen aan/uit.</li>
          <li>Tekenen (klik & sleep) of dubbelklik voor snelle 4u-dienst.</li>
          <li>Medewerkers kiezen via zoek & chips. Pauze instellen of op <b>Auto</b>.</li>
          <li><b>Controleren</b> toont overlappen &amp; openingstijd-issues.</li>
          <li><b>Week leegmaken</b> wist alle diensten uit het canvas van deze week.</li>
          <li>Opslaan als concept of <b>Publiceren</b> (leden zien alleen published).</li>
        </ol>
      </div>
    </div>
  </div>

  <script src="manage.js"></script>
</body>
</html>
