'use strict';

(async function(){
  const $ = (q)=>document.querySelector(q);

  const id=$('#id'), type=$('#type'), scope=$('#scope'), title=$('#title'), message=$('#message'), start=$('#start'), end=$('#end');
  const deptChecks=$('#deptChecks'), scopeDept=$('#scopeDept'), scopeUser=$('#scopeUser');
  const userSearch=$('#userSearch'), userList=$('#userList');
  const save=$('#save'), reset=$('#reset'), msg=$('#msg');

  const fltType=$('#fltType'), fltActive=$('#fltActive'), fltDept=$('#fltDept'), reload=$('#reload'), table=$('#table');

  let departments=[], users=[], selectedUsers=new Set(), selectedDepts=new Set();

  function esc(s){ return (s||'').replace(/[&<>"]/g, c=>({ '&':'&amp;','<':'&lt;','>':'&gt;' }[c])); }
  function notice(t){ msg.hidden=false; msg.textContent=t; }

  function toggleScopeUI(){
    scopeDept.hidden = scope.value!=='department';
    scopeUser.hidden = scope.value!=='user';
  }

  async function loadDeps(){
    const d = await fetch('/api/departments/list.php').then(r=>r.json());
    departments = d.ok?d.items:[];
    deptChecks.innerHTML='';
    fltDept.innerHTML='<option value="0">Alle</option>'+departments.map(x=>`<option value="${x.id}">${esc(x.name)}</option>`).join('');
    departments.forEach(dep=>{
      const lab = document.createElement('label'); lab.className='check';
      lab.innerHTML = `<input type="checkbox" value="${dep.id}"><span>${esc(dep.name)}</span>`;
      const cb=lab.querySelector('input');
      cb.addEventListener('change',()=>{ if(cb.checked) selectedDepts.add(Number(cb.value)); else selectedDepts.delete(Number(cb.value)); });
      deptChecks.appendChild(lab);
    });
  }
  async function loadUsers(){
    const u = await fetch('/api/users/list.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({})}).then(r=>r.json());
    users = u.ok?u.items:[];
    renderUserList('');
  }
  function renderUserList(q){
    const ql=(q||'').toLowerCase(); userList.innerHTML='';
    users.filter(u=>!q || (u.name||'').toLowerCase().includes(ql) || (u.email||'').toLowerCase().includes(ql))
      .forEach(u=>{
        const row=document.createElement('div'); row.className='row';
        row.innerHTML = `<div>${esc(u.name)} <span class="muted" style="color:#64748b">${esc(u.email||'')}</span></div>
                         <div><input type="checkbox" ${selectedUsers.has(u.id)?'checked':''}></div>`;
        row.querySelector('input').addEventListener('change',(e)=>{ if(e.target.checked) selectedUsers.add(u.id); else selectedUsers.delete(u.id); });
        userList.appendChild(row);
      });
  }
  userSearch.addEventListener('input',()=> renderUserList(userSearch.value));
  scope.addEventListener('change', toggleScopeUI);

  // Save
  save.addEventListener('click', async (e)=>{
    e.preventDefault(); msg.hidden=true;
    const body = {
      id: id.value ? Number(id.value) : undefined,
      type: type.value, scope: scope.value,
      title: title.value.trim(),
      message: message.value.trim(),
      start_at: start.value ? start.value.replace('T',' ')+':00' : null,
      end_at:   end.value   ? end.value.replace('T',' ')+':00'   : null,
      department_ids: Array.from(selectedDepts),
      user_ids: Array.from(selectedUsers),
    };
    const res = await fetch('/api/announcements/upsert.php', {method:'POST',headers:{'Content-Type':'application/json'}, body:JSON.stringify(body)});
    const data = await res.json();
    if(!res.ok || !data.ok){ notice(data.error||'Opslaan mislukt'); return; }
    notice('Opgeslagen'); id.value=data.id;
    await loadTable();
  });

  reset.addEventListener('click', (e)=>{
    e.preventDefault(); msg.hidden=true;
    id.value=''; type.value='activity'; scope.value='global';
    title.value=''; message.value=''; start.value=''; end.value='';
    selectedUsers.clear(); selectedDepts.clear();
    deptChecks.querySelectorAll('input[type="checkbox"]').forEach(cb=>cb.checked=false);
    renderUserList(userSearch.value); toggleScopeUI();
  });

  // Tabel
  async function loadTable(){
    const body={ type: fltType.value||undefined, active: (fltActive.value===''?undefined:(fltActive.value==='1')), department_id: Number(fltDept.value||0) || undefined };
    const res=await fetch('/api/announcements/list.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(body)});
    const data=await res.json();
    const items = data.ok?data.items:[];
    table.innerHTML = `
      <div class="thead">
        <div>Type</div><div>Titel</div><div>Periode</div><div>Bereik</div><div>Laatst</div><div></div>
      </div>
      ${items.map(it=>{
        const badge=`<span class="badge type-${it.type}">${it.type}</span>`;
        const per = (it.start_at?it.start_at.substring(0,16):'')+' – '+(it.end_at?it.end_at.substring(0,16):'');
        return `<div class="row" data-id="${it.id}">
          <div>${badge}</div>
          <div>${esc(it.title)}</div>
          <div>${esc(per)}</div>
          <div>${esc(it.scope)}</div>
          <div>${esc(it.updated_at||it.created_at||'')}</div>
          <div class="controls">
            <button class="link act-edit">Bewerken</button>
            <button class="link act-del">Verwijderen</button>
          </div>
        </div>`;
      }).join('')}`;
    table.querySelectorAll('.act-edit').forEach(btn=>{
      btn.addEventListener('click', ()=> {
        const row = btn.closest('.row'); const rid = Number(row.dataset.id);
        const it = items.find(x=>Number(x.id)===rid); if(!it) return;
        id.value=it.id; type.value=it.type; scope.value=it.scope;
        title.value=it.title; message.value=it.message||'';
        start.value = it.start_at ? it.start_at.replace(' ','T').slice(0,16) : '';
        end.value   = it.end_at   ? it.end_at.replace(' ','T').slice(0,16)   : '';
        // haal geselecteerde mapping op
        selectedUsers.clear(); selectedDepts.clear();
        // Kleine extra call om mapping op te halen zou kunnen, maar voor compactheid laten we gebruiker evt. opnieuw kiezen.
        toggleScopeUI(); notice('Geselecteerd om te bewerken');
      });
    });
    table.querySelectorAll('.act-del').forEach(btn=>{
      btn.addEventListener('click', async ()=> {
        const row = btn.closest('.row'); const rid = Number(row.dataset.id);
        if(!confirm('Verwijderen?')) return;
        const rp = await fetch('/api/announcements/delete.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({id:rid})});
        const dj = await rp.json(); if(!rp.ok||!dj.ok){ alert(dj.error||'Mislukt'); return; }
        await loadTable();
      });
    });
  }
  reload.addEventListener('click', loadTable);

  await loadDeps(); await loadUsers(); toggleScopeUI(); await loadTable();
})();
