<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login();
$userId = (int)$_SESSION['user']['id'];

$in = rp_json_input();
/** expected: [{weekday:1..7, start:"HH:MM", end:"HH:MM"}, ...] */
$rows = is_array($in['slots'] ?? null) ? $in['slots'] : [];
if (!$rows) rp_json(['ok'=>false,'error'=>'Geen gegevens'], 422);

// Validatie & normalisatie
$clean = [];
foreach ($rows as $r) {
  $w = (int)($r['weekday'] ?? 0);
  $s = trim((string)($r['start'] ?? ''));
  $e = trim((string)($r['end'] ?? ''));
  if ($w < 1 || $w > 7 || !preg_match('/^\d{2}:\d{2}$/', $s) || !preg_match('/^\d{2}:\d{2}$/', $e)) continue;
  if (strtotime("1970-01-01 $e:00") <= strtotime("1970-01-01 $s:00")) continue;
  $clean[] = [$w, "$s:00", "$e:00"];
}

try {
  $pdo->beginTransaction();
  $pdo->prepare('DELETE FROM user_availability WHERE user_id=?')->execute([$userId]);
  $ins = $pdo->prepare('INSERT INTO user_availability (user_id, weekday, start_time, end_time) VALUES (?,?,?,?)');
  foreach ($clean as $c) { $ins->execute([$userId, $c[0], $c[1], $c[2]]); }
  $pdo->commit();
  rp_json(['ok'=>true]);
} catch (Exception $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  rp_json(['ok'=>false,'error'=>'Opslaan mislukt'], 500);
}
